from axelrod.action import Action, actions_to_str

from axelrod.player import Player

from axelrod.strategy_transformers import (
    FinalTransformer,
    TrackHistoryTransformer,
)

C, D = Action.C, Action.D

class Michaelos(Player):
    """
    Plays similar to Tit-for-Tat with two exceptions:
    1) Defect on last turn.
    2) After own defection and opponent's cooperation, 50 percent of the time,
    cooperate. The other 50 percent of the time, always defect for the rest of
    the game.

    Names:

    - Michaelos: [LessWrong2011]_
    """

    name = "Michaelos"
    classifier = {
        "memory_depth": float("inf"),
        "stochastic": True,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def __init__(self):
        super().__init__()
        self.is_defector = False

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        if not self.history:
            return C
        if self.is_defector:
            return D
        if self.history[-1] == D and opponent.history[-1] == C:
            decision = self._random.random_choice()
            if decision == C:
                return C
            else:
                self.is_defector = True
                return D

        return opponent.history[-1]